package org.msh.tb.bd.dashboard.summaryrep.parser;

import org.msh.tb.bd.Quarter;
import org.msh.tb.bd.dashboard.DashboardIndicatorUtils;
import org.msh.tb.bd.dashboard.summaryrep.data.GeoDistributionData;
import org.msh.tb.bd.dashboard.summaryrep.data.IndicatorRateData;
import org.msh.tb.bd.dashboard.summaryrep.data.SummaryIndicatorData;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.utils.date.Period;

import java.util.List;

/**
 * Created by mauri on 23/05/2017.
 * Parses information returned from IndicatorQuery to a SummaryIndicatorData object
 */
public class GeoDistributionParser {

    public GeoDistributionData parse(List<Object[]> result, String locationDesc) {
        Quarter quarter = Quarter.getCurrentQuarter().getPreviousQuarter();

        GeoDistributionData data = new GeoDistributionData();
        data.setLocationDesc(locationDesc);
        data.setPeriodDesc(quarter.getQuarter().getKey() + ".2");
        data.setPeriodDescParam(quarter.getYear()+"");

        for (Object[] o : result) {
            AdministrativeUnit au = (AdministrativeUnit) o[0];
            Long qtt = (Long) o[1];
            data.addItem(au.getFullDisplayName2(), qtt.floatValue(), au.getLatitude(), au.getLongitude());
        }

        return data;
    }

    public Period getPeriod() {
        return DashboardIndicatorUtils.getLastQuarterPeriod();
    }
}
